# -*- coding:utf-8 -*-
from django.core.management.base import BaseCommand
import datetime
import time
__author__ = 'Arvin'


class Command(BaseCommand):
    option_list = BaseCommand.option_list + ()
    help = "Starts Process Device Transaction ."
    args = ''

    def handle(self, *args, **options):
        from mysite.sql_utils import get_sql, p_execute
        from mysite import const
        frequency = const.TRANSACTION_SYNC_FREQUENCY
        while True:
            try:
                now = datetime.datetime.now().strftime("%Y-%m-%d %H:%M:%S")
                params = {
                    'check_time': now,
                }
                sql = get_sql('sql', sqlid='sync_device_transaction', app='iclock', params=params)
                p_execute(sql)
                update_sql = get_sql('sql', sqlid='update_device_transaction_status', app='iclock', params=params)
                p_execute(update_sql)
                time.sleep(frequency)
            except Exception, e:
                print e
                time.sleep(3 * 60)